/*! For license information please see mmd.domWidget.min.js.LICENSE.txt */
!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.MMD=e():t.MMD=e()}(self,(()=>(()=>{"use strict";var __webpack_modules__={"./node_modules/eventemitter3/index.js":module=>{eval("\n\nvar has = Object.prototype.hasOwnProperty\n  , prefix = '~';\n\n/**\n * Constructor to create a storage for our `EE` objects.\n * An `Events` instance is a plain object whose properties are event names.\n *\n * @constructor\n * @private\n */\nfunction Events() {}\n\n//\n// We try to not inherit from `Object.prototype`. In some engines creating an\n// instance in this way is faster than calling `Object.create(null)` directly.\n// If `Object.create(null)` is not supported we prefix the event names with a\n// character to make sure that the built-in object properties are not\n// overridden or used as an attack vector.\n//\nif (Object.create) {\n  Events.prototype = Object.create(null);\n\n  //\n  // This hack is needed because the `__proto__` property is still inherited in\n  // some old browsers like Android 4, iPhone 5.1, Opera 11 and Safari 5.\n  //\n  if (!new Events().__proto__) prefix = false;\n}\n\n/**\n * Representation of a single event listener.\n *\n * @param {Function} fn The listener function.\n * @param {*} context The context to invoke the listener with.\n * @param {Boolean} [once=false] Specify if the listener is a one-time listener.\n * @constructor\n * @private\n */\nfunction EE(fn, context, once) {\n  this.fn = fn;\n  this.context = context;\n  this.once = once || false;\n}\n\n/**\n * Add a listener for a given event.\n *\n * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn The listener function.\n * @param {*} context The context to invoke the listener with.\n * @param {Boolean} once Specify if the listener is a one-time listener.\n * @returns {EventEmitter}\n * @private\n */\nfunction addListener(emitter, event, fn, context, once) {\n  if (typeof fn !== 'function') {\n    throw new TypeError('The listener must be a function');\n  }\n\n  var listener = new EE(fn, context || emitter, once)\n    , evt = prefix ? prefix + event : event;\n\n  if (!emitter._events[evt]) emitter._events[evt] = listener, emitter._eventsCount++;\n  else if (!emitter._events[evt].fn) emitter._events[evt].push(listener);\n  else emitter._events[evt] = [emitter._events[evt], listener];\n\n  return emitter;\n}\n\n/**\n * Clear event by name.\n *\n * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.\n * @param {(String|Symbol)} evt The Event name.\n * @private\n */\nfunction clearEvent(emitter, evt) {\n  if (--emitter._eventsCount === 0) emitter._events = new Events();\n  else delete emitter._events[evt];\n}\n\n/**\n * Minimal `EventEmitter` interface that is molded against the Node.js\n * `EventEmitter` interface.\n *\n * @constructor\n * @public\n */\nfunction EventEmitter() {\n  this._events = new Events();\n  this._eventsCount = 0;\n}\n\n/**\n * Return an array listing the events for which the emitter has registered\n * listeners.\n *\n * @returns {Array}\n * @public\n */\nEventEmitter.prototype.eventNames = function eventNames() {\n  var names = []\n    , events\n    , name;\n\n  if (this._eventsCount === 0) return names;\n\n  for (name in (events = this._events)) {\n    if (has.call(events, name)) names.push(prefix ? name.slice(1) : name);\n  }\n\n  if (Object.getOwnPropertySymbols) {\n    return names.concat(Object.getOwnPropertySymbols(events));\n  }\n\n  return names;\n};\n\n/**\n * Return the listeners registered for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @returns {Array} The registered listeners.\n * @public\n */\nEventEmitter.prototype.listeners = function listeners(event) {\n  var evt = prefix ? prefix + event : event\n    , handlers = this._events[evt];\n\n  if (!handlers) return [];\n  if (handlers.fn) return [handlers.fn];\n\n  for (var i = 0, l = handlers.length, ee = new Array(l); i < l; i++) {\n    ee[i] = handlers[i].fn;\n  }\n\n  return ee;\n};\n\n/**\n * Return the number of listeners listening to a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @returns {Number} The number of listeners.\n * @public\n */\nEventEmitter.prototype.listenerCount = function listenerCount(event) {\n  var evt = prefix ? prefix + event : event\n    , listeners = this._events[evt];\n\n  if (!listeners) return 0;\n  if (listeners.fn) return 1;\n  return listeners.length;\n};\n\n/**\n * Calls each of the listeners registered for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @returns {Boolean} `true` if the event had listeners, else `false`.\n * @public\n */\nEventEmitter.prototype.emit = function emit(event, a1, a2, a3, a4, a5) {\n  var evt = prefix ? prefix + event : event;\n\n  if (!this._events[evt]) return false;\n\n  var listeners = this._events[evt]\n    , len = arguments.length\n    , args\n    , i;\n\n  if (listeners.fn) {\n    if (listeners.once) this.removeListener(event, listeners.fn, undefined, true);\n\n    switch (len) {\n      case 1: return listeners.fn.call(listeners.context), true;\n      case 2: return listeners.fn.call(listeners.context, a1), true;\n      case 3: return listeners.fn.call(listeners.context, a1, a2), true;\n      case 4: return listeners.fn.call(listeners.context, a1, a2, a3), true;\n      case 5: return listeners.fn.call(listeners.context, a1, a2, a3, a4), true;\n      case 6: return listeners.fn.call(listeners.context, a1, a2, a3, a4, a5), true;\n    }\n\n    for (i = 1, args = new Array(len -1); i < len; i++) {\n      args[i - 1] = arguments[i];\n    }\n\n    listeners.fn.apply(listeners.context, args);\n  } else {\n    var length = listeners.length\n      , j;\n\n    for (i = 0; i < length; i++) {\n      if (listeners[i].once) this.removeListener(event, listeners[i].fn, undefined, true);\n\n      switch (len) {\n        case 1: listeners[i].fn.call(listeners[i].context); break;\n        case 2: listeners[i].fn.call(listeners[i].context, a1); break;\n        case 3: listeners[i].fn.call(listeners[i].context, a1, a2); break;\n        case 4: listeners[i].fn.call(listeners[i].context, a1, a2, a3); break;\n        default:\n          if (!args) for (j = 1, args = new Array(len -1); j < len; j++) {\n            args[j - 1] = arguments[j];\n          }\n\n          listeners[i].fn.apply(listeners[i].context, args);\n      }\n    }\n  }\n\n  return true;\n};\n\n/**\n * Add a listener for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn The listener function.\n * @param {*} [context=this] The context to invoke the listener with.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.on = function on(event, fn, context) {\n  return addListener(this, event, fn, context, false);\n};\n\n/**\n * Add a one-time listener for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn The listener function.\n * @param {*} [context=this] The context to invoke the listener with.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.once = function once(event, fn, context) {\n  return addListener(this, event, fn, context, true);\n};\n\n/**\n * Remove the listeners of a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn Only remove the listeners that match this function.\n * @param {*} context Only remove the listeners that have this context.\n * @param {Boolean} once Only remove one-time listeners.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.removeListener = function removeListener(event, fn, context, once) {\n  var evt = prefix ? prefix + event : event;\n\n  if (!this._events[evt]) return this;\n  if (!fn) {\n    clearEvent(this, evt);\n    return this;\n  }\n\n  var listeners = this._events[evt];\n\n  if (listeners.fn) {\n    if (\n      listeners.fn === fn &&\n      (!once || listeners.once) &&\n      (!context || listeners.context === context)\n    ) {\n      clearEvent(this, evt);\n    }\n  } else {\n    for (var i = 0, events = [], length = listeners.length; i < length; i++) {\n      if (\n        listeners[i].fn !== fn ||\n        (once && !listeners[i].once) ||\n        (context && listeners[i].context !== context)\n      ) {\n        events.push(listeners[i]);\n      }\n    }\n\n    //\n    // Reset the array, or remove it completely if we have no more listeners.\n    //\n    if (events.length) this._events[evt] = events.length === 1 ? events[0] : events;\n    else clearEvent(this, evt);\n  }\n\n  return this;\n};\n\n/**\n * Remove all listeners, or those of the specified event.\n *\n * @param {(String|Symbol)} [event] The event name.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.removeAllListeners = function removeAllListeners(event) {\n  var evt;\n\n  if (event) {\n    evt = prefix ? prefix + event : event;\n    if (this._events[evt]) clearEvent(this, evt);\n  } else {\n    this._events = new Events();\n    this._eventsCount = 0;\n  }\n\n  return this;\n};\n\n//\n// Alias methods names because people roll like that.\n//\nEventEmitter.prototype.off = EventEmitter.prototype.removeListener;\nEventEmitter.prototype.addListener = EventEmitter.prototype.on;\n\n//\n// Expose the prefix.\n//\nEventEmitter.prefixed = prefix;\n\n//\n// Allow `EventEmitter` to be imported as module namespace.\n//\nEventEmitter.EventEmitter = EventEmitter;\n\n//\n// Expose the module.\n//\nif (true) {\n  module.exports = EventEmitter;\n}\n\n\n//# sourceURL=webpack://MMD/./node_modules/eventemitter3/index.js?")},"./src/app.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "DomWidget": () => (/* reexport safe */ _view_Scene__WEBPACK_IMPORTED_MODULE_0__.Scene)\n/* harmony export */ });\n/* harmony import */ var _view_Scene__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./view/Scene */ "./src/view/Scene.ts");\n/**\r\n * Created by quanchen on 2022/9/19.\r\n */\r\n\r\n\n\n//# sourceURL=webpack://MMD/./src/app.ts?')},"./src/math/Matrix2D.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (/* binding */ Matrix2D)\n/* harmony export */ });\n/**\r\n * Created by quanchen on 2022/9/19.\r\n */\r\nclass Matrix2D {\r\n    constructor(a = 1, b = 0, c = 0, d = 1, tx = 0, ty = 0) {\r\n        this.setValues(a, b, c, d, tx, ty);\r\n    }\r\n    setValues(a, b, c, d, tx, ty) {\r\n        this.a = (a == null) ? 1 : a;\r\n        this.b = b || 0;\r\n        this.c = c || 0;\r\n        this.d = (d == null) ? 1 : d;\r\n        this.tx = tx || 0;\r\n        this.ty = ty || 0;\r\n        return this;\r\n    }\r\n    append(a, b, c, d, tx, ty) {\r\n        const a1 = this.a;\r\n        const b1 = this.b;\r\n        const c1 = this.c;\r\n        const d1 = this.d;\r\n        if (a != 1 || b != 0 || c != 0 || d != 1) {\r\n            this.a = a1 * a + c1 * b;\r\n            this.b = b1 * a + d1 * b;\r\n            this.c = a1 * c + c1 * d;\r\n            this.d = b1 * c + d1 * d;\r\n        }\r\n        this.tx = a1 * tx + c1 * ty + this.tx;\r\n        this.ty = b1 * tx + d1 * ty + this.ty;\r\n        return this;\r\n    }\r\n    prepend(a, b, c, d, tx, ty) {\r\n        const a1 = this.a;\r\n        const c1 = this.c;\r\n        const tx1 = this.tx;\r\n        this.a = a * a1 + c * this.b;\r\n        this.b = b * a1 + d * this.b;\r\n        this.c = a * c1 + c * this.d;\r\n        this.d = b * c1 + d * this.d;\r\n        this.tx = a * tx1 + c * this.ty + tx;\r\n        this.ty = b * tx1 + d * this.ty + ty;\r\n        return this;\r\n    }\r\n    appendMatrix(matrix) {\r\n        return this.append(matrix.a, matrix.b, matrix.c, matrix.d, matrix.tx, matrix.ty);\r\n    }\r\n    prependMatrix(matrix) {\r\n        return this.prepend(matrix.a, matrix.b, matrix.c, matrix.d, matrix.tx, matrix.ty);\r\n    }\r\n    appendTransform(x, y, scaleX, scaleY, rotation, skewX, skewY, regX, regY) {\r\n        let cos;\r\n        let sin;\r\n        if (rotation % 360) {\r\n            const r = rotation * Matrix2D.DEG_TO_RAD;\r\n            cos = Math.cos(r);\r\n            sin = Math.sin(r);\r\n        }\r\n        else {\r\n            cos = 1;\r\n            sin = 0;\r\n        }\r\n        if (skewX || skewY) {\r\n            // TODO: can this be combined into a single append operation?\r\n            skewX *= Matrix2D.DEG_TO_RAD;\r\n            skewY *= Matrix2D.DEG_TO_RAD;\r\n            this.append(Math.cos(skewY), Math.sin(skewY), -Math.sin(skewX), Math.cos(skewX), x, y);\r\n            this.append(cos * scaleX, sin * scaleX, -sin * scaleY, cos * scaleY, 0, 0);\r\n        }\r\n        else {\r\n            this.append(cos * scaleX, sin * scaleX, -sin * scaleY, cos * scaleY, x, y);\r\n        }\r\n        if (regX || regY) {\r\n            // append the registration offset:\r\n            this.tx -= regX * this.a + regY * this.c;\r\n            this.ty -= regX * this.b + regY * this.d;\r\n        }\r\n        return this;\r\n    }\r\n    prependTransform(x, y, scaleX, scaleY, rotation, skewX, skewY, regX, regY) {\r\n        let cos;\r\n        let sin;\r\n        if (rotation % 360) {\r\n            const r = rotation * Matrix2D.DEG_TO_RAD;\r\n            cos = Math.cos(r);\r\n            sin = Math.sin(r);\r\n        }\r\n        else {\r\n            cos = 1;\r\n            sin = 0;\r\n        }\r\n        if (regX || regY) {\r\n            // prepend the registration offset:\r\n            this.tx -= regX;\r\n            this.ty -= regY;\r\n        }\r\n        if (skewX || skewY) {\r\n            // TODO: can this be combined into a single prepend operation?\r\n            skewX *= Matrix2D.DEG_TO_RAD;\r\n            skewY *= Matrix2D.DEG_TO_RAD;\r\n            this.prepend(cos * scaleX, sin * scaleX, -sin * scaleY, cos * scaleY, 0, 0);\r\n            this.prepend(Math.cos(skewY), Math.sin(skewY), -Math.sin(skewX), Math.cos(skewX), x, y);\r\n        }\r\n        else {\r\n            this.prepend(cos * scaleX, sin * scaleX, -sin * scaleY, cos * scaleY, x, y);\r\n        }\r\n        return this;\r\n    }\r\n    rotate(angle) {\r\n        angle = angle * Matrix2D.DEG_TO_RAD;\r\n        const cos = Math.cos(angle);\r\n        const sin = Math.sin(angle);\r\n        const a1 = this.a;\r\n        const b1 = this.b;\r\n        this.a = a1 * cos + this.c * sin;\r\n        this.b = b1 * cos + this.d * sin;\r\n        this.c = -a1 * sin + this.c * cos;\r\n        this.d = -b1 * sin + this.d * cos;\r\n        return this;\r\n    }\r\n    skew(skewX, skewY) {\r\n        skewX = skewX * Matrix2D.DEG_TO_RAD;\r\n        skewY = skewY * Matrix2D.DEG_TO_RAD;\r\n        this.append(Math.cos(skewY), Math.sin(skewY), -Math.sin(skewX), Math.cos(skewX), 0, 0);\r\n        return this;\r\n    }\r\n    scale(x, y) {\r\n        this.a *= x;\r\n        this.b *= x;\r\n        this.c *= y;\r\n        this.d *= y;\r\n        // this.tx *= x;\r\n        // this.ty *= y;\r\n        return this;\r\n    }\r\n    translate(x, y) {\r\n        this.tx += this.a * x + this.c * y;\r\n        this.ty += this.b * x + this.d * y;\r\n        return this;\r\n    }\r\n    identity() {\r\n        this.a = 1;\r\n        this.d = 1;\r\n        this.b = 0;\r\n        this.c = 0;\r\n        this.tx = 0;\r\n        this.ty = 0;\r\n        return this;\r\n    }\r\n    invert() {\r\n        const a1 = this.a;\r\n        const b1 = this.b;\r\n        const c1 = this.c;\r\n        const d1 = this.d;\r\n        const tx1 = this.tx;\r\n        const n = a1 * d1 - b1 * c1;\r\n        this.a = d1 / n;\r\n        this.b = -b1 / n;\r\n        this.c = -c1 / n;\r\n        this.d = a1 / n;\r\n        this.tx = (c1 * this.ty - d1 * tx1) / n;\r\n        this.ty = -(a1 * this.ty - b1 * tx1) / n;\r\n        return this;\r\n    }\r\n    isIdentity() {\r\n        return this.tx === 0 && this.ty === 0 && this.a === 1 && this.b === 0 && this.c === 0 && this.d === 1;\r\n    }\r\n    equals(matrix) {\r\n        return this.tx === matrix.tx\r\n            && this.ty === matrix.ty\r\n            && this.a === matrix.a\r\n            && this.b === matrix.b\r\n            && this.c === matrix.c\r\n            && this.d === matrix.d;\r\n    }\r\n    transformPoint(x, y, pt) {\r\n        pt = pt || { x: 0, y: 0 };\r\n        pt.x = x * this.a + y * this.c + this.tx;\r\n        pt.y = x * this.b + y * this.d + this.ty;\r\n        return pt;\r\n    }\r\n    decompose(target) {\r\n        // TODO: it would be nice to be able to solve for whether the matrix can be decomposed\r\n        //  into only scale/rotation even when scale is negative\r\n        if (target == null) {\r\n            target = {};\r\n        }\r\n        target.x = this.tx;\r\n        target.y = this.ty;\r\n        target.scaleX = Math.sqrt(this.a * this.a + this.b * this.b);\r\n        target.scaleY = Math.sqrt(this.c * this.c + this.d * this.d);\r\n        const skewX = Math.atan2(-this.c, this.d);\r\n        const skewY = Math.atan2(this.b, this.a);\r\n        const delta = Math.abs(1 - skewX / skewY);\r\n        if (delta < 0.00001) { // effectively identical, can use rotation:\r\n            target.rotation = skewY / Matrix2D.DEG_TO_RAD;\r\n            if (this.a < 0 && this.d >= 0) {\r\n                target.rotation += (target.rotation <= 0) ? 180 : -180;\r\n            }\r\n            target.skewX = 0;\r\n            target.skewY = 0;\r\n        }\r\n        else {\r\n            target.skewX = skewX / Matrix2D.DEG_TO_RAD;\r\n            target.skewY = skewY / Matrix2D.DEG_TO_RAD;\r\n        }\r\n        return target;\r\n    }\r\n    copy(matrix) {\r\n        return this.setValues(matrix.a, matrix.b, matrix.c, matrix.d, matrix.tx, matrix.ty);\r\n    }\r\n    clone() {\r\n        return new Matrix2D(this.a, this.b, this.c, this.d, this.tx, this.ty);\r\n    }\r\n    toString() {\r\n        return `[Matrix2D (a=${this.a} b=${this.b} c=${this.c} d=${this.d} tx=${this.tx} ty=${this.ty})]`;\r\n    }\r\n}\r\nMatrix2D.DEG_TO_RAD = Math.PI / 180;\r\n\n\n//# sourceURL=webpack://MMD/./src/math/Matrix2D.ts?')},"./src/utils/StageContext.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "ScaleMode": () => (/* binding */ ScaleMode),\n/* harmony export */   "default": () => (/* binding */ StageContext)\n/* harmony export */ });\n/**\r\n * Created by quanchen on 2022/9/19.\r\n */\r\nvar ScaleMode;\r\n(function (ScaleMode) {\r\n    /**\r\n     *裁剪铺满,保持比例;\r\n     */\r\n    ScaleMode["NO_BORDER"] = "NOBORDER";\r\n    /**\r\n     * 不缩放;\r\n     */\r\n    ScaleMode["NO_SCALE"] = "NOSCALE";\r\n    /**\r\n     * 显示全部,保持比例;\r\n     */\r\n    ScaleMode["SHOW_ALL"] = "SHOWALL";\r\n    /**\r\n     * 宽度100%,保持比例;\r\n     */\r\n    ScaleMode["WIDTH"] = "WIDTH";\r\n    /**\r\n     * 高度100%,保持比例;\r\n     */\r\n    ScaleMode["HEIGHT"] = "HEIGHT";\r\n    /**\r\n     * 宽高等于屏幕宽高,不保持比例;\r\n     */\r\n    ScaleMode["EXACT_FIT"] = "EXACTFIT";\r\n})(ScaleMode || (ScaleMode = {}));\r\nclass StageContext {\r\n    constructor(width, height) {\r\n        this.setSize(width, height);\r\n    }\r\n    get scaleMode() {\r\n        return this._scaleMode;\r\n    }\r\n    set scaleMode(value) {\r\n        this._scaleMode = value;\r\n    }\r\n    set width(value) {\r\n        this._width = value;\r\n    }\r\n    get width() {\r\n        return this._width;\r\n    }\r\n    set height(value) {\r\n        this._height = value;\r\n    }\r\n    get height() {\r\n        return this._height;\r\n    }\r\n    get align() {\r\n        return this._align;\r\n    }\r\n    set align(value) {\r\n        this._align = value;\r\n    }\r\n    get type() {\r\n        return this._type;\r\n    }\r\n    set type(value) {\r\n        this._type = value;\r\n    }\r\n    /**\r\n     * 设置宽度,高度;\r\n     * @param width\r\n     * @param height\r\n     */\r\n    setSize(width, height) {\r\n        this._width = width;\r\n        this._height = height;\r\n    }\r\n    /**\r\n     * 更新数据;\r\n     * @param stageWidth\r\n     * @param stageHeight\r\n     * @param rotation\r\n     */\r\n    update(stageWidth, stageHeight, rotation) {\r\n        // 当前横竖屏状态;\r\n        const isH = this.type.toLocaleLowerCase() === \'h\';\r\n        let width = stageWidth;\r\n        let height = stageHeight;\r\n        // 根据当前旋转度数重新设置宽高;\r\n        if (isH) {\r\n            if (rotation === 0) {\r\n                width = stageHeight;\r\n                height = stageWidth;\r\n            }\r\n        }\r\n        else {\r\n            if (rotation !== 0) {\r\n                width = stageHeight;\r\n                height = stageWidth;\r\n            }\r\n        }\r\n        let data;\r\n        let isAlign = false;\r\n        // 缩放方式处理;\r\n        switch (this.scaleMode.toUpperCase()) {\r\n            case ScaleMode.EXACT_FIT:\r\n                data = this.exactFit(width, height);\r\n                break;\r\n            case ScaleMode.NO_BORDER:\r\n                isAlign = true;\r\n                data = this.noBorder(width, height);\r\n                break;\r\n            case ScaleMode.NO_SCALE:\r\n                isAlign = true;\r\n                data = this.noScale();\r\n                break;\r\n            case ScaleMode.SHOW_ALL:\r\n                isAlign = true;\r\n                data = this.showAll(width, height);\r\n                break;\r\n            case ScaleMode.WIDTH:\r\n                isAlign = true;\r\n                data = this.exactWidth(width);\r\n                break;\r\n            case ScaleMode.HEIGHT:\r\n                isAlign = true;\r\n                data = this.exactHeight(height);\r\n                break;\r\n            default:\r\n                data = {\r\n                    x: 0, y: 0,\r\n                    width, height,\r\n                    scaleX: 1, scaleY: 1,\r\n                    rotation,\r\n                };\r\n                break;\r\n        }\r\n        // 旋转处理\r\n        if (isH) {\r\n            switch (rotation) {\r\n                case -90:\r\n                case 90:\r\n                    data.rotation = 0;\r\n                    break;\r\n                default:\r\n                    data.rotation = -90;\r\n                    break;\r\n            }\r\n        }\r\n        else {\r\n            data.rotation = rotation;\r\n        }\r\n        const isRt = data.rotation !== -90 && (!isH || data.rotation !== 0);\r\n        const rWidth = (width - data.width);\r\n        const rHeight = (height - data.height);\r\n        // 对齐方式处理;\r\n        if (isAlign) {\r\n            switch (this.align.toLowerCase()) {\r\n                case \'l\':\r\n                    data.x = isRt ? (data.rotation !== 0 ? rWidth : 0) : 0;\r\n                    data.y = (height - data.height) / 2;\r\n                    break;\r\n                case \'t\':\r\n                    data.x = (width - data.width) / 2;\r\n                    data.y = isRt ? 0 : isH ? (data.rotation !== 0 ? rHeight : 0) : rHeight;\r\n                    break;\r\n                case \'r\':\r\n                    data.x = isRt ? (width - data.width) - (data.rotation === 0 ? 0 : rWidth) : (width - data.width);\r\n                    data.y = (height - data.height) / 2;\r\n                    break;\r\n                case \'b\':\r\n                    data.x = (width - data.width) / 2;\r\n                    data.y = isRt ? (height - data.height) : (isH ? (data.rotation !== 0 ? 0 : rHeight) : 0);\r\n                    break;\r\n                case \'lt\':\r\n                case \'tl\':\r\n                    data.x = isRt ? (data.rotation !== 0 ? rWidth : 0) : 0;\r\n                    data.y = isRt ? 0 : isH ? (data.rotation !== 0 ? rHeight : 0) : rHeight;\r\n                    break;\r\n                case \'rt\':\r\n                case \'tr\':\r\n                    data.x = isRt ? (width - data.width) - (data.rotation === 0 ? 0 : rWidth) : (width - data.width);\r\n                    data.y = isRt ? 0 : isH ? (data.rotation !== 0 ? rHeight : 0) : rHeight;\r\n                    break;\r\n                case \'bl\':\r\n                case \'lb\':\r\n                    data.x = isRt ? (data.rotation !== 0 ? rWidth : 0) : 0;\r\n                    data.y = isRt ? (height - data.height) : (isH ? (data.rotation !== 0 ? 0 : rHeight) : 0);\r\n                    break;\r\n                case \'br\':\r\n                case \'rb\':\r\n                    data.x = isRt ? (width - data.width) - (data.rotation === 0 ? 0 : rWidth) : (width - data.width);\r\n                    data.y = isRt ? (height - data.height) : (isH ? (data.rotation !== 0 ? 0 : rHeight) : 0);\r\n                    break;\r\n                default:\r\n                    data.x = (width - data.width) / 2;\r\n                    data.y = (height - data.height) / 2;\r\n                    break;\r\n            }\r\n        }\r\n        // 旋转后坐标处理;\r\n        if (data.rotation !== 0) {\r\n            const ox = data.x;\r\n            const oy = data.y;\r\n            if (data.rotation === -90) {\r\n                data.x = (data.scaleY * this.height) + oy;\r\n                data.y = ox;\r\n            }\r\n            else {\r\n                data.y = (data.scaleX * this.width) + ox;\r\n                data.x = oy;\r\n            }\r\n        }\r\n        data.stageWidth = width;\r\n        data.stageHeight = height;\r\n        return data;\r\n    }\r\n    /**\r\n     * 宽高等于屏幕宽高,比例会变;\r\n     * @param w\r\n     * @param h\r\n     * @private\r\n     */\r\n    exactFit(w, h) {\r\n        const { width, height } = this;\r\n        return {\r\n            x: 0, y: 0,\r\n            width, height,\r\n            scaleX: w / width, scaleY: h / height,\r\n            rotation: 0,\r\n        };\r\n    }\r\n    /**\r\n     * 裁剪铺满,保持比例;\r\n     * @param w\r\n     * @param h\r\n     * @private\r\n     */\r\n    noBorder(w, h) {\r\n        const { width, height } = this;\r\n        const ratio = height / width;\r\n        let scale = w / width;\r\n        if (ratio < h / w) {\r\n            scale = h / height;\r\n        }\r\n        return {\r\n            x: 0, y: 0,\r\n            width: scale * width, height: scale * height,\r\n            scaleX: scale, scaleY: scale,\r\n            rotation: 0,\r\n        };\r\n    }\r\n    /**\r\n     * 不缩放;\r\n     * @private\r\n     */\r\n    noScale() {\r\n        const { width, height } = this;\r\n        return {\r\n            x: 0, y: 0,\r\n            width, height,\r\n            scaleX: 1, scaleY: 1,\r\n            rotation: 0,\r\n        };\r\n    }\r\n    /**\r\n     * 显示全部,保持比例,上下左右可能出现背景;\r\n     * @param w\r\n     * @param h\r\n     * @private\r\n     */\r\n    showAll(w, h) {\r\n        const { width, height } = this;\r\n        const ratio = height / width;\r\n        let scale = w / width;\r\n        if (ratio > h / w) {\r\n            scale = h / height;\r\n        }\r\n        return {\r\n            x: 0, y: 0,\r\n            width: scale * width, height: scale * height,\r\n            scaleX: scale, scaleY: scale,\r\n            rotation: 0,\r\n        };\r\n    }\r\n    /**\r\n     * 宽度100% 保持比例 上下可能出现背景;\r\n     * @param w\r\n     * @private\r\n     */\r\n    exactWidth(w) {\r\n        const { width, height } = this;\r\n        const scale = w / width;\r\n        return {\r\n            x: 0, y: 0,\r\n            width: width * scale, height: height * scale,\r\n            scaleX: scale, scaleY: scale,\r\n            rotation: 0,\r\n        };\r\n    }\r\n    /**\r\n     * 高度100% 保持比例 左右可能出现背景;\r\n     * @param h\r\n     * @private\r\n     */\r\n    exactHeight(h) {\r\n        const { width, height } = this;\r\n        const scale = h / height;\r\n        return {\r\n            x: 0, y: 0,\r\n            width: width * scale, height: height * scale,\r\n            scaleX: scale, scaleY: scale,\r\n            rotation: 0,\r\n        };\r\n    }\r\n}\r\n\r\n\n\n//# sourceURL=webpack://MMD/./src/utils/StageContext.ts?')},"./src/view/Children.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Children)\n/* harmony export */ });\n/* harmony import */ var _math_Matrix2D__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math/Matrix2D */ \"./src/math/Matrix2D.ts\");\n/* harmony import */ var _utils_StageContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/StageContext */ \"./src/utils/StageContext.ts\");\n/* harmony import */ var eventemitter3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! eventemitter3 */ \"./node_modules/eventemitter3/index.js\");\n/* harmony import */ var eventemitter3__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(eventemitter3__WEBPACK_IMPORTED_MODULE_2__);\n/**\r\n * Created by quanchen on 2022/9/19.\r\n */\r\n\r\n\r\n\r\nconst OPTS_DEFAULT = {\r\n    width: 400,\r\n    height: 400,\r\n    scale: _utils_StageContext__WEBPACK_IMPORTED_MODULE_1__.ScaleMode.NO_BORDER,\r\n    rotation: 'auto',\r\n    align: '',\r\n    mode: 'v',\r\n};\r\nconst CHILD_DEFAULT = {\r\n    width: 100,\r\n    height: 100,\r\n    x: 0,\r\n    y: 0,\r\n};\r\nfunction setStyle(style, mtx) {\r\n    const n = 10000;\r\n    const str = `matrix3d(${(mtx.a * n | 0) / n},${(mtx.b * n | 0) / n},0,0,${(mtx.c * n | 0) / n},${(mtx.d * n | 0) / n},0,0,0,0,1,0,${mtx.tx + 0.5 | 0},${mtx.ty + 0.5 | 0},0,1)`;\r\n    style.transform = str;\r\n    // @ts-ignore;\r\n    style.webkitTransform = str;\r\n    // @ts-ignore;\r\n    style.OTransform = str;\r\n    // @ts-ignore;\r\n    style.msTransform = str;\r\n}\r\nclass Children extends (eventemitter3__WEBPACK_IMPORTED_MODULE_2___default()) {\r\n    constructor(_target) {\r\n        super();\r\n        this._target = _target;\r\n        this.matrix = new _math_Matrix2D__WEBPACK_IMPORTED_MODULE_0__[\"default\"]();\r\n        this._stage = new _utils_StageContext__WEBPACK_IMPORTED_MODULE_1__[\"default\"](OPTS_DEFAULT.width, OPTS_DEFAULT.height);\r\n        this.target = _target;\r\n    }\r\n    get options() {\r\n        return this._options;\r\n    }\r\n    set options(value) {\r\n        this._options = value;\r\n        const { _target, _stage } = this;\r\n        if (_target) {\r\n            _target.setAttribute('view-width', value.width.toString());\r\n            _target.setAttribute('view-height', value.height.toString());\r\n            _target.setAttribute('view-scale', value.scale);\r\n            _target.setAttribute('view-rotation', value.rotation);\r\n            _target.setAttribute('view-align', value.align);\r\n            _target.setAttribute('view-mode', value.mode);\r\n        }\r\n        _stage.width = value.width;\r\n        _stage.height = value.height;\r\n        _stage.align = value.align;\r\n        _stage.scaleMode = value.scale;\r\n        _stage.type = value.mode;\r\n        _target.style.width = `${value.width}px`;\r\n        _target.style.height = `${value.height}px`;\r\n    }\r\n    get matrix() {\r\n        return this._matrix;\r\n    }\r\n    set matrix(value) {\r\n        this._matrix = value;\r\n    }\r\n    get target() {\r\n        return this._target;\r\n    }\r\n    set target(value) {\r\n        this._target = value;\r\n        if (value) {\r\n            value.style.position = 'absolute';\r\n            value.style.transformOrigin = '0% 0%';\r\n            // @ts-ignore;\r\n            value.style.WebkitTransformOrigin = '0% 0%';\r\n            // @ts-ignore;\r\n            value.style.msTransformOrigin = '0% 0%';\r\n            // @ts-ignore;\r\n            value.style.MozTransformOrigin = '0% 0%';\r\n            // @ts-ignore;\r\n            value.style.OTransformOrigin = '0% 0%';\r\n            const opts = {\r\n                width: Number(value.getAttribute('view-width')),\r\n                height: Number(value.getAttribute('view-height')),\r\n                scale: value.getAttribute('view-scale'),\r\n                rotation: value.getAttribute('view-rotation'),\r\n                align: value.getAttribute('view-align'),\r\n                mode: value.getAttribute('view-mode'),\r\n            };\r\n            for (const i in opts) {\r\n                // @ts-ignore\r\n                if (!opts[i]) {\r\n                    // @ts-ignore\r\n                    opts[i] = OPTS_DEFAULT[i];\r\n                }\r\n            }\r\n            value.style.width = `${opts.width}px`;\r\n            value.style.height = `${opts.height}px`;\r\n            value.style.overflow = 'hidden';\r\n            this.options = opts;\r\n        }\r\n    }\r\n    update(width, height, rotation) {\r\n        if (this.options.rotation.toLocaleLowerCase() === 'v') {\r\n            this.target.style.display = rotation !== 0 ? 'none' : 'block';\r\n        }\r\n        if (this.options.rotation.toLocaleLowerCase() === 'h') {\r\n            this.target.style.display = rotation === 0 ? 'none' : 'block';\r\n        }\r\n        if (this.options.rotation.toLocaleLowerCase() === 'auto') {\r\n            this.target.style.display = 'block';\r\n        }\r\n        if (this.target.style.display !== 'block')\r\n            return;\r\n        const rect = this._stage.update(width, height, rotation);\r\n        const matrix = new _math_Matrix2D__WEBPACK_IMPORTED_MODULE_0__[\"default\"]();\r\n        matrix.rotate(-rect.rotation);\r\n        matrix.tx = rect.x;\r\n        matrix.ty = rect.y;\r\n        matrix.scale(rect.scaleX, rect.scaleY);\r\n        this.matrix = matrix;\r\n        this.sendEvent(this.target, 'rectangle', rect);\r\n        setStyle(this.target.style, this.matrix);\r\n        const o = this.parsePoint(rect, this.options.align);\r\n        this.sendEvent(this.target, 'position', o);\r\n        this.updateChild(rect);\r\n    }\r\n    sendEvent(target, type, data) {\r\n        if (document.createEvent) {\r\n            const e = document.createEvent('Event');\r\n            e.initEvent(type, true, true);\r\n            // @ts-ignore;\r\n            e.data = data;\r\n            target.dispatchEvent(e);\r\n        }\r\n    }\r\n    parsePoint(rect, align) {\r\n        const isH = this._stage.type.toLocaleLowerCase() === 'h';\r\n        let rx;\r\n        let ry;\r\n        let left;\r\n        let right;\r\n        let top;\r\n        let bottom;\r\n        if (isH) {\r\n            switch (rect.rotation) {\r\n                case -90:\r\n                case 90:\r\n                    left = -(rect.y) / rect.scaleY;\r\n                    top = -(rect.stageHeight - (rect.x)) / rect.scaleX;\r\n                    right = left + rect.stageWidth / rect.scaleX;\r\n                    bottom = top + rect.stageHeight / rect.scaleY;\r\n                    break;\r\n                case 0:\r\n                    left = -(rect.x) / rect.scaleX;\r\n                    top = -(rect.y) / rect.scaleY;\r\n                    right = left + rect.stageWidth / rect.scaleX;\r\n                    bottom = top + rect.stageHeight / rect.scaleX;\r\n                    break;\r\n            }\r\n        }\r\n        else {\r\n            switch (rect.rotation) {\r\n                case 0:\r\n                    top = -(rect.y) / rect.scaleY;\r\n                    left = -(rect.x) / rect.scaleX;\r\n                    right = left + rect.stageWidth / rect.scaleX;\r\n                    bottom = top + rect.stageHeight / rect.scaleY;\r\n                    break;\r\n                case -90:\r\n                    top = -(rect.stageHeight - (rect.x)) / rect.scaleX;\r\n                    left = -(rect.y) / rect.scaleY;\r\n                    right = left + rect.stageWidth / rect.scaleX;\r\n                    bottom = top + rect.stageHeight / rect.scaleY;\r\n                    break;\r\n                case 90:\r\n                    left = -(rect.stageWidth - (rect.y)) / rect.scaleY;\r\n                    top = -(rect.x) / rect.scaleX;\r\n                    right = left + rect.stageWidth / rect.scaleY;\r\n                    bottom = top + rect.stageHeight / rect.scaleX;\r\n                    break;\r\n            }\r\n        }\r\n        rx = left + (right - left) / 2;\r\n        ry = top + (bottom - top) / 2;\r\n        if (align !== undefined) {\r\n            switch (align.toLocaleLowerCase()) {\r\n                case 't':\r\n                    ry = top;\r\n                    break;\r\n                case 'l':\r\n                    rx = left;\r\n                    break;\r\n                case 'r':\r\n                    rx = right;\r\n                    break;\r\n                case 'b':\r\n                    ry = bottom;\r\n                    break;\r\n                case 'tl':\r\n                case 'lt':\r\n                    rx = left;\r\n                    ry = top;\r\n                    break;\r\n                case 'tr':\r\n                case 'rt':\r\n                    rx = right;\r\n                    ry = top;\r\n                    break;\r\n                case 'bl':\r\n                case 'lb':\r\n                    rx = left;\r\n                    ry = bottom;\r\n                    break;\r\n                case 'rb':\r\n                case 'br':\r\n                    rx = right;\r\n                    ry = bottom;\r\n                    break;\r\n            }\r\n            // child.style.top = `${ry - height / 2 + y}px`;\r\n            // child.style.left = `${rx - width / 2 + x}px`;\r\n        }\r\n        return { x: rx, y: ry, top, left, right, bottom };\r\n    }\r\n    updateChild(rect) {\r\n        if (this.target) {\r\n            const { childNodes } = this.target;\r\n            let x;\r\n            let y;\r\n            let align;\r\n            let child;\r\n            let rx;\r\n            let ry;\r\n            let left;\r\n            let right;\r\n            let top;\r\n            let bottom;\r\n            let width;\r\n            let height;\r\n            const isH = this._stage.type.toLocaleLowerCase() === 'h';\r\n            for (let i = 0; i < childNodes.length; i++) {\r\n                child = childNodes[i];\r\n                if (child.getAttribute) {\r\n                    align = child.hasAttribute('view-align') ? child.getAttribute('view-align') : undefined;\r\n                    width = Number(child.getAttribute('view-width')) || CHILD_DEFAULT.width;\r\n                    height = Number(child.getAttribute('view-height')) || CHILD_DEFAULT.height;\r\n                    x = (Number(child.getAttribute('view-x')) || CHILD_DEFAULT.x);\r\n                    y = (Number(child.getAttribute('view-y')) || CHILD_DEFAULT.y);\r\n                    const o = this.parsePoint(rect, align);\r\n                    // align = '';\r\n                    // console.log('rect:', rect);\r\n                    // console.log('align:', align, width, height, x, y);\r\n                    if (align !== undefined) {\r\n                        child.style.left = `${o.x - width / 2 + x}px`;\r\n                        child.style.top = `${o.y - height / 2 + y}px`;\r\n                        // console.log('left 0:', o.x - width / 2 + x, 'top 0:', o.y - height / 2 + y);\r\n                        // child.style.top = `${o.x - height / 2 + y}px`;\r\n                        // child.style.left = `${o.y - width / 2 + x}px`;\r\n                    }\r\n                    if (align !== undefined) {\r\n                        // set style;\r\n                        if (child.style.position !== 'absolute')\r\n                            child.style.position = 'absolute';\r\n                        // 范围限制;\r\n                        let rx = o.x;\r\n                        let ry = o.y;\r\n                        rx = Math.min(rect.width / rect.scaleX, Math.max(0, rx));\r\n                        ry = Math.min(rect.height / rect.scaleY, Math.max(0, ry));\r\n                        child.style.left = `${rx - width / 2 + x}px`;\r\n                        child.style.top = `${ry - height / 2 + y}px`;\r\n                    }\r\n                    // this.sendEvent(child, 'position', { target: child, top, left, right, bottom });\r\n                }\r\n            }\r\n        }\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack://MMD/./src/view/Children.ts?")},"./src/view/Scene.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Scene\": () => (/* binding */ Scene)\n/* harmony export */ });\n/* harmony import */ var eventemitter3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! eventemitter3 */ \"./node_modules/eventemitter3/index.js\");\n/* harmony import */ var eventemitter3__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(eventemitter3__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Children__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Children */ \"./src/view/Children.ts\");\n/**\r\n * Created by quanchen on 2022/9/19.\r\n */\r\n\r\n\r\nclass Scene extends (eventemitter3__WEBPACK_IMPORTED_MODULE_0___default()) {\r\n    constructor() {\r\n        super();\r\n        this._isReady = false;\r\n        this.init();\r\n    }\r\n    static getInstance() {\r\n        if (!this.instance)\r\n            this.instance = new Scene();\r\n        return this.instance;\r\n    }\r\n    /**\r\n     * 更新dom配置;\r\n     * @param id\r\n     * @param config -1:全部更新 >=0或string则只更新对应元素;\r\n     */\r\n    updateConfig(config, id = -1) {\r\n        console.log(config, id);\r\n        let list;\r\n        if (typeof id === 'number') {\r\n            if (id !== -1) {\r\n                const element = this._list[id];\r\n                if (!element) {\r\n                    console.error('找不到元素 id:', id);\r\n                    return;\r\n                }\r\n            }\r\n            list = id === -1 ? this._list : [this._list[id]];\r\n        }\r\n        else {\r\n            const element = this._list.find(value => value.target.id === id);\r\n            if (!element) {\r\n                console.error('找不到元素 id:', id);\r\n                return;\r\n            }\r\n            list = [element];\r\n        }\r\n        list.forEach((value) => {\r\n            value.options = Object.assign(Object.assign({}, value.options), config);\r\n        });\r\n        this.onResize();\r\n    }\r\n    update() {\r\n        console.log('update');\r\n        this._list = [];\r\n        this.onInserted({ target: document.body });\r\n        this.onResize();\r\n    }\r\n    /**\r\n     * dom widget 准备完成回调;\r\n     * @param fun\r\n     */\r\n    onReady(fun) {\r\n        if (!this._readyFunList.includes(fun))\r\n            this._readyFunList.push(fun);\r\n        // console.log('onReady this._readyFunList:', this._readyFunList);\r\n        if (this._isReady) {\r\n            this._readyFunList.forEach(value => value());\r\n        }\r\n    }\r\n    init() {\r\n        // console.log('scene');\r\n        this._orientation = (window.innerWidth < window.innerHeight ? 0 : 90) || 0;\r\n        this._list = [];\r\n        this._readyFunList = [];\r\n        window.addEventListener('DOMContentLoaded', this.onContentLoaded.bind(this));\r\n        window.addEventListener('orientationchange', this.onOrientation.bind(this));\r\n        window.addEventListener('resize', this.onResize.bind(this));\r\n    }\r\n    createTime() {\r\n        clearTimeout(this._tid);\r\n        let tid = 0;\r\n        const fun = () => {\r\n            this.updateList();\r\n            tid += 1;\r\n            if (tid > 10) {\r\n                clearTimeout(this._tid);\r\n            }\r\n        };\r\n        fun();\r\n        this._tid = setInterval(fun, 100);\r\n    }\r\n    onOrientation() {\r\n        void 0 !== (window.innerWidth < window.innerHeight ? 0 : 90)\r\n            && (this._orientation = (window.innerWidth < window.innerHeight ? 0 : 90));\r\n        this.createTime();\r\n    }\r\n    onResize() {\r\n        void 0 !== (window.innerWidth < window.innerHeight ? 0 : 90)\r\n            && (this._orientation = window.innerWidth < window.innerHeight ? 0 : 90);\r\n        this.onOrientation();\r\n        this.createTime();\r\n    }\r\n    onContentLoaded() {\r\n        window.addEventListener('DOMNodeInserted', this.onInserted.bind(this));\r\n        window.addEventListener('DOMNodeRemoved', this.onRemoved.bind(this));\r\n        this.onInserted({ target: document.body });\r\n        this._isReady = true;\r\n        this._readyFunList.forEach(value => value());\r\n    }\r\n    onRemoved(e) {\r\n        this.removeItem(e.target);\r\n    }\r\n    onInserted(e) {\r\n        // console.log('onInserted e:', e);\r\n        this.checkNodes(e.target);\r\n    }\r\n    checkNodes(child) {\r\n        const { childNodes } = child;\r\n        if (child.getAttribute) {\r\n            const isRotation = child.getAttribute('view-mode');\r\n            if (!!isRotation) {\r\n                if (!this.checkItem(child) && this.checkParent(child)) {\r\n                    let c;\r\n                    try {\r\n                        c = new _Children__WEBPACK_IMPORTED_MODULE_1__[\"default\"](child);\r\n                    }\r\n                    catch (e) {\r\n                        console.error(e);\r\n                    }\r\n                    this.addItem(c);\r\n                }\r\n            }\r\n        }\r\n        for (let i = 0; i < childNodes.length; i++) {\r\n            const childNode = childNodes[i];\r\n            this.checkNodes(childNode);\r\n        }\r\n    }\r\n    checkParent(child) {\r\n        const parent = child.parentNode;\r\n        // @ts-ignore;\r\n        if (parent && parent !== document) {\r\n            if (!!parent.getAttribute('view-mode')) {\r\n                return false;\r\n            }\r\n            return this.checkParent(parent);\r\n        }\r\n        return true;\r\n    }\r\n    addItem(child) {\r\n        this.removeItem(child.target);\r\n        this._list.push(child);\r\n        void 0 === (window.innerWidth < window.innerHeight ? 0 : 90)\r\n            && (this._orientation = window.innerWidth < window.innerHeight ? 0 : 90);\r\n        this.createTime();\r\n    }\r\n    checkItem(child) {\r\n        return !!this._list.find(value => value.target === child);\r\n    }\r\n    removeItem(child) {\r\n        this._list = this._list.filter(value => value.target !== child);\r\n    }\r\n    updateList() {\r\n        if (window.innerWidth < window.innerHeight) {\r\n            this._orientation = 0;\r\n        }\r\n        else {\r\n            this._orientation = 90;\r\n        }\r\n        const width = window.innerWidth;\r\n        const height = window.innerHeight;\r\n        for (let i = 0; i < this._list.length; i++) {\r\n            const listElement = this._list[i];\r\n            listElement.update(width, height, this._orientation);\r\n        }\r\n    }\r\n}\r\nScene.getInstance();\r\n\r\n\n\n//# sourceURL=webpack://MMD/./src/view/Scene.ts?")}},__webpack_module_cache__={};function __webpack_require__(t){var e=__webpack_module_cache__[t];if(void 0!==e)return e.exports;var n=__webpack_module_cache__[t]={exports:{}};return __webpack_modules__[t](n,n.exports,__webpack_require__),n.exports}__webpack_require__.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return __webpack_require__.d(e,{a:e}),e},__webpack_require__.d=(t,e)=>{for(var n in e)__webpack_require__.o(e,n)&&!__webpack_require__.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},__webpack_require__.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),__webpack_require__.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./src/app.ts");return __webpack_exports__})()));